global script_node

local controls = FindNodeByName("AllControlsScript")
local prop = FindNodeByName("Ob_6_2Prop")
local handlestate

handlestate = 0

-- door release lever

global function AnimDone()
	local anim
	local ce7 = FindNodeByName("ce7")
	
	if (handlestate == 0) then
		anim = FindNodeByShortName("EM_ANIMATOR_Handle_Large_Anim_Panel06_Handle_Large_Down_Idle")	
	else
		anim = FindNodeByShortName("EM_ANIMATOR_Handle_Large_Anim_Panel06_Handle_Large_Up_Idle")
		ce7:Trigger()
	end

	prop:PlayAnim(anim, 1, 0)
	controls.script.TurnOnInterface()
	--Locking down mech
	controls.script.InteractDone()
end

global function PlayUp()
	local anim = FindNodeByShortName("EM_ANIMATOR_Handle_Large_Anim_Panel06_Handle_Large_Up")

	handlestate = 1

	FindNodeByName("Ob6_2SoundUp"):Trigger()
	
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function PlayDown()
	local anim = FindNodeByShortName("EM_ANIMATOR_Handle_Large_Anim_Panel06_Handle_Large_Down")

	handlestate = 0

	FindNodeByName("Ob6_2SoundDown"):Trigger()
	
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function Interact()
	local doctor = GetActor("doctor")
	local amy = GetActor("amy")

	controls.script.TurnOffInterface()
	
	if (handlestate == 0) then
		PlayUp()
	else
		PlayDown()
	end

	FindNodeByName("Console6InteractableScript").script.Object2State = handlestate

	-- ConsoleDV == 0 is for when exploring tardis
	if controls.script.ConsoleDV == 0 then
		SayPrep("skip","async")

		if(FindNodeByName("CommonScripts").script.DoctorIsPlayer()) then
			--VO Console Control Text - door release lever (doc)
			doctor::SID_2291:Door Release Lever: Locks and unlocks the doors. I'm always forgetting and walking into them.
		else
			--VO Console Control Text - door release lever (amy)
			amy::SID_2292:I've used this before, it locks and unlocks the doors. Easy.
		end
	end
end

global function DummyCallback()
end

global function ResetControl()
	local anim

	if handlestate == 0 then
		anim = FindNodeByShortName("EM_ANIMATOR_Handle_Large_Anim_Panel06_Handle_Large_Down_Idle")
	else
		anim = FindNodeByShortName("EM_ANIMATOR_Handle_Large_Anim_Panel06_Handle_Large_Down")
	end

	prop:SetCallback(script_node, "DummyCallback")	-- overrides the current callback so nothing happens
	prop:PlayAnim(anim, 1, 0)
	handlestate = 0
end
